﻿var messagesTranslationEditor = {
    context: $(".v-translateMessages"),
    questionnaireId: 0,
    bindEvents: function () {
        $(".v-translateLanguage, .v-referenceLanguage", messagesTranslationEditor.context).each(function () {
            $(this).data("prev", $(this).val());
        });

        messagesTranslationEditor.context.on("change", ".v-translateLanguage, .v-referenceLanguage", function () {
            var select = $(this);
            var currentValue = select.val();
            var previousValue = select.data("prev");

            if (messagesTranslationEditor.hasUnsavedChanges())
            {
                modalDialog.showUnsavedChangesDialog(function () {
                    select.val(previousValue);
                    $.when(messagesTranslationEditor.saveMessages())
                     .then(function () {
                         select.val(currentValue);
                         select.data("prev", currentValue);
                         messagesTranslationEditor.updateMessagesEditor();
                     });
                }, function () {
                    select.data("prev", currentValue);
                    messagesTranslationEditor.updateMessagesEditor();
                }, function () {
                    select.val(previousValue);
                });
            }
            else
            {
                select.data("prev", currentValue);
                messagesTranslationEditor.updateMessagesEditor();
            }
        });

        messagesTranslationEditor.context.on("click", ".v-saveQuestion", function () {
            $.when(messagesTranslationEditor.saveMessages()).then(function () { modalDialog.close(); });
        });

        messagesTranslationEditor.context.on("change", ".v-message", function () {
            $(this).attr("data-changed", "true");
        });
    },
    updateMessagesEditor: function () {
        var translationEdition = $("#messagesTranslationEditor .v-translatorContainer", messagesTranslationEditor.context);
        var translationLanguage = $(".v-translateLanguage", messagesTranslationEditor.context).val();
        var referenceLanguage = $(".v-referenceLanguage", messagesTranslationEditor.context).val();

        var args = {
            questionnaireId: messagesTranslationEditor.questionnaireId,
            referenceLanguage: referenceLanguage,
            translationLanguage: translationLanguage
        };

        a4.callServerMethod(a4.getAction("GetTranslateMessagesEditor", "Home", "Project"), args, function (result) {
            translationEdition.empty().append(result);
        });
    },
    saveMessages: function () {
        var messages = {};

        $(".v-message[data-changed='true']", messagesTranslationEditor.context).map(function () { return messagesTranslationEditor.textObject(messages, $(this)); });

        var args = {
            questionnaireId: messagesTranslationEditor.questionnaireId,
            messages: ($.isEmptyObject(messages) ? null : messages),
            language: $(".v-translateLanguage", messagesTranslationEditor.context).val()
        };

        return a4.callServerMethod(a4.getAction("UpdateMessages", "Home", "Project"), args, function (result) {
            a4.showSuccessMessage(resources.SuccessMessage, 2000);
        });
    },
    hasUnsavedChanges: function () {
        return $(".v-message[data-changed='true']", messagesTranslationEditor.context).length > 0;
    },
    textObject: function (texts, $textBox) {
        var key = $textBox.attr("data-key");
        var value = "";

        value = $textBox.val().trim();

        texts[key] = value;
    }
}

$(document).ready(function () {
    if (messagesTranslationEditor.context.length > 0) {
        messagesTranslationEditor.questionnaireId = $("#QuestionnaireId", messagesTranslationEditor.context).val();
        messagesTranslationEditor.bindEvents();
    }
});